/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.adapter.JXP;
import woolpack.el.FixEL;
import woolpack.el.PathEL;
import woolpack.test.TestUtils;

public class ReplaceTextToChildTest extends TestCase {

	public void testConstructor() {
		try {
			new ReplaceTextToChild(null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal0() {
		final DomExpression expression = new Serial(TestUtils
				.getToNodeForm("<TEXTAREA name=\"name0\" >value0</TEXTAREA>"),
				new XPath(new JXP("name", "name0"), new ReplaceTextToChild(
						new FixEL("value1"))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context,
				"<TEXTAREA name=\"name0\" >value1</TEXTAREA>"));
	}

	public void testNormal1() {
		final DomExpression expression = new Serial(TestUtils
				.getToNodeForm("<TEXTAREA name=\"name0\" >value0</TEXTAREA>"),
				new XPath(new JXP("name", "name0"), new ReplaceTextToChild(
						new PathEL("local.value1"))));
		final DomContext context = new DomContext();
		context.getLocal().put("value1", "value2");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context,
				"<TEXTAREA name=\"name0\" >value2</TEXTAREA>"));
	}
}
