/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.el.PathEL;
import woolpack.utils.SwitchBuilder;

public class DumpIfCatchTest extends TestCase {

	public void testConstructor() {
		try {
			new DumpIfCatch(null);
			fail();
		} catch (final NullPointerException e) {
		}
	}

	public void testNormal() {
		final Count counter0 = new Count(DomConstants.NULL);
		final DomExpression expression = new DumpIfCatch(counter0);
		final DomContext context = new DomContext();
		context.setId("id0");
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
	}

	public void testException() {
		final Count counter0 = new Count(new Branch<Object>(new EvalEL(null,
				new PathEL("context.session.hoge.piyo")),
				new SwitchBuilder<Object, DomExpression>().get()));
		final DomExpression expression = new DumpIfCatch(counter0);
		final DomContext context = new DomContext();
		context.setId("id0");
		try {
			expression.interpret(context);
			fail();
		} catch (final IllegalStateException expected) {
			assertTrue(expected.getCause() instanceof NullPointerException);
			assertEquals(
					"DomContext dump information:\n,id:id0\n,config:\n,container:\n,input:\n,request:\n,session:\n,application:\n,local:\n,node:",
					expected.getMessage());
		}
		assertEquals(1, counter0.getCount());
	}
}
