package woolpack.dom;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.utils.MapBuilder;

public class BranchButtonTest extends TestCase {

	public void testConstractor() {
		try {
			new BranchButton(null, new HashMap<String, Map<String, String>>());
			fail();
		} catch (final NullPointerException e) {
		}
		try {
			new BranchButton("", new HashMap<String, Map<String, String>>());
			fail();
		} catch (final StringIndexOutOfBoundsException e) {
		}
		try {
			new BranchButton("buttonKind", null);
			fail();
		} catch (final NullPointerException e) {
		}
	}

	public void testNormal() {
		final DomExpression expression = new BranchButton("buttonKind",
				MapBuilder.get(new HashMap<String, Map<String, String>>()).put(
						"branch0",
						MapBuilder.get(new HashMap<String, String>()).put(
								"param0", "id00").put("param1", "id01").get())
						.put(
								"branch1",
								MapBuilder.get(new HashMap<String, String>())
										.put("label0", "id10").put("label1",
												"id11").get()).get());
		final DomContext context = new DomContext();
		final Map<String, Object> input = new HashMap<String, Object>();
		context.setInput(input);

		context.setId("branch0");
		input.put("buttonKind", "param0");
		expression.interpret(context);
		assertEquals("id00", context.getId());

		context.setId("branch0");
		input.put("buttonKind", "param1");
		expression.interpret(context);
		assertEquals("id01", context.getId());

		context.setId("branch1");
		input.put("label0", "param0");
		expression.interpret(context);
		assertEquals("id10", context.getId());

		context.setId("branch1");
		input.remove("label0");
		input.put("label1", "param0");
		expression.interpret(context);
		assertEquals("id11", context.getId());
	}
}
