/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import woolpack.adapter.HSQLDBConstants;

import junit.framework.TestCase;

public class UpdatableFactoryImplTest extends TestCase {
	public void testException() {
		final DataSource dataSource = HSQLDBConstants.getMemoryDataSource("mydb1_UpdatableFactoryImplTest");
		final Executable executable = new PreparedStatementExecutor(dataSource);
		new FixUpdater("create memory table my_table (" +
				"my_id integer, " +
				"my_seq integer, " +
				"my_string varchar, " +
				"my_int integer, " +
				"constraint MYTALBE0P primary key (my_id, my_seq))", dataSource).update(null);
		final List<TableInfo> tableInfoList = CrudConstants.getTableInfoList(dataSource);
		final Map<String, TableInfo> tableInfoMap = CrudConstants.convertJavaNameTableInfoMap(tableInfoList);
		final UpdatableFactory factory = new UpdatableFactoryImpl(
				new ExpressionFactoryImpl(tableInfoMap, CrudConstants.SELECT),
				executable);
		final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
		map.put("myId", Arrays.asList((Object)Integer.valueOf(0)));
		map.put("mySeq", Arrays.asList((Object)Integer.valueOf(0)));
		map.put("myString", Arrays.asList((Object)"myString0"));
		map.put("myInt", Arrays.asList((Object)Integer.valueOf(0)));
		final int result = factory.newInstance("myTable", map).update(map);
		assertEquals(-1, result);
	}
}
