/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import junit.framework.TestCase;

public class InputMapPointerTest extends TestCase {
	
	public void testEquals() {
		assertFalse(new InputMapPointer("key0", 0).equals(new Object()));
		{
			final InputMapPointer p = new InputMapPointer("key0", 0);
			assertTrue(p.equals(p));
		}
		assertTrue(new InputMapPointer("key0", 0).equals(new InputMapPointer("key0", 0)));
		assertFalse(new InputMapPointer("key0", 0).equals(new InputMapPointer("key0", 1)));
		assertFalse(new InputMapPointer("key0", 0).equals(new InputMapPointer("key1", 0)));
		assertFalse(new InputMapPointer("key0", 0).equals(new InputMapPointer("key1", 1)));
	}
	
	public void testHashCode() {
		assertEquals(new InputMapPointer("key0", 0).hashCode(), new InputMapPointer("key0", 0).hashCode());
	}
}
