/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import java.util.Arrays;
import java.util.Iterator;

import junit.framework.TestCase;
import woolpack.el.ELConstants;
import woolpack.el.FixEL;
import woolpack.el.GettingEL;

public class ActionDefTest extends TestCase {

	public void testConstructor() {
		try {
			new ActionDef(null, ELConstants.NULL, new ForwardDef("forwardId0",
					ELConstants.NULL, ActionConstants.ANY));
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new ActionDef(ELConstants.NULL, (GettingEL) null, new ForwardDef(
					"forwardId0", ELConstants.NULL, ActionConstants.ANY));
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new ActionDef(ELConstants.NULL, ELConstants.NULL,
					(Iterable<ForwardDef>) null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testGet() {
		final GettingEL el = new FixEL("method0");
		final ForwardDef forwardDef = new ForwardDef("forwardId0",
				ELConstants.NULL, ActionConstants.ANY);
		final ActionDef def = new ActionDef(el, forwardDef);
		assertEquals(ELConstants.NULL, def.getComponentEL());
		assertEquals(el, def.getMethodEL());
		final Iterator<ForwardDef> iterator = def.getForwardDefIterable()
				.iterator();
		assertTrue(iterator.hasNext());
		assertEquals(forwardDef, iterator.next());
		assertFalse(iterator.hasNext());
	}

	public void testGet2() {
		final GettingEL el = new FixEL("method0");
		final ForwardDef forwardDef = new ForwardDef("forwardId0",
				ELConstants.NULL, ActionConstants.ANY);
		final ActionDef def = new ActionDef(el, Arrays.asList(forwardDef));
		assertEquals(ELConstants.NULL, def.getComponentEL());
		assertEquals(el, def.getMethodEL());
		final Iterator<ForwardDef> iterator = def.getForwardDefIterable()
				.iterator();
		assertTrue(iterator.hasNext());
		assertEquals(forwardDef, iterator.next());
		assertFalse(iterator.hasNext());
	}
}
