/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import junit.framework.TestCase;

public class ActionConstantsTest extends TestCase {

	public void testAny() {
		final ForwardMatchable matcher = ActionConstants.ANY;
		assertTrue(matcher.matches(null));
		assertTrue(matcher.matches("a"));
		assertTrue(matcher.matches("b"));
		assertTrue(matcher.matches(new Exception()));
		assertTrue(matcher.matches(new RuntimeException()));
		assertTrue(matcher.matches(new IndexOutOfBoundsException()));
		assertTrue(matcher.matches(new ArrayIndexOutOfBoundsException()));
	}

	public void testNotThrowable() {
		final ForwardMatchable matcher = ActionConstants.NOT_THROWABLE;
		assertTrue(matcher.matches(null));
		assertTrue(matcher.matches("a"));
		assertTrue(matcher.matches("b"));
		assertFalse(matcher.matches(new Throwable()));
		assertFalse(matcher.matches(new Exception()));
		assertFalse(matcher.matches(new RuntimeException()));
		assertFalse(matcher.matches(new IndexOutOfBoundsException()));
		assertFalse(matcher.matches(new ArrayIndexOutOfBoundsException()));
	}
}
