/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor.impl;

import woolpack.validator.CountValidator;
import woolpack.validator.DelegationValidator;
import woolpack.validator.DumpValidator;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;

/**
 * インスタンスの変数のみを{@link Visitor#visit(Object)}に渡す{@link Acceptable}を定義した
 * 定数の集まり。
 * 
 * @author nakamura
 * 
 */
public final class IgnoreValidatorConstants {

	/**
	 * {@link CountValidator#getExpression()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<CountValidator> IGNORE_COUNT_VALIDATOR
	= new Acceptable<CountValidator>() {
		public void accept(final Visitor visitor, final CountValidator v) {
			visitor.visit(v.getExpression());
		}
	};

	/**
	 * {@link DelegationValidator#getExpression()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<DelegationValidator>
	IGNORE_DELEGATION_VALIDATOR
	= new Acceptable<DelegationValidator>() {
		public void accept(final Visitor visitor, final DelegationValidator v) {
			visitor.visit(v.getExpression());
		}
	};

	/**
	 * {@link DumpValidator#getExpression()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<DumpValidator> IGNORE_DUMP_VALIDATOR
	= new Acceptable<DumpValidator>() {
		public void accept(final Visitor visitor, final DumpValidator v) {
			visitor.visit(v.getExpression());
		}
	};

	private IgnoreValidatorConstants() {
	} // カバレージがここを通過してはいけない
}
