/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor.impl;

import woolpack.text.DelegateDateFormat;
import woolpack.text.DelegateNumberFormat;
import woolpack.text.FormatFactory;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;

/**
 * インスタンスの変数のみを{@link Visitor#visit(Object)}に渡す{@link Acceptable}を定義した
 * 定数の集まり。
 * 
 * @author nakamura
 * 
 */
public final class IgnoreTextConstants {

	/**
	 * {@link FormatFactory#newInstance()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<FormatFactory> IGNORE_FORMAT_FACTORY
	= new Acceptable<FormatFactory>() {
		public void accept(final Visitor visitor, final FormatFactory v) {
			visitor.visit(v.newInstance());
		}
	};

	/**
	 * {@link DelegateDateFormat#getDateFormat()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<DelegateDateFormat>
	IGNORE_DELEGATE_DATE_FORMAT
	= new Acceptable<DelegateDateFormat>() {
		public void accept(final Visitor visitor, final DelegateDateFormat v) {
			visitor.visit(v.getDateFormat());
		}
	};

	/**
	 * {@link DelegateNumberFormat#getNumberFormat()}のみを
	 * {@link Visitor#visit(Object)}に渡す{@link Acceptable}。
	 */
	public static final Acceptable<DelegateNumberFormat>
	IGNORE_DELEGATE_NUMBER_FORMAT
	= new Acceptable<DelegateNumberFormat>() {
		public void accept(
				final Visitor visitor,
				final DelegateNumberFormat v) {
			visitor.visit(v.getNumberFormat());
		}
	};

	private IgnoreTextConstants() {
	} // カバレージがここを通過してはいけない
}
