/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

/**
 * 一時インデックスを{@link ValidatorContext#setTmpIndex(int)}
 * に設定して委譲する{@link ValidatorExpression}。
 * 
 * @author nakamura
 * 
 */
public class TmpIndexValidator extends DelegationValidator {
	private final int tmpIndex;

	/**
	 * コンストラクタ。
	 * 
	 * @param tmpIndex
	 *            一時インデックス。
	 * @param expression
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 * @throws IllegalArgumentException
	 *             tmpIndex が負の場合。
	 */
	public TmpIndexValidator(final int tmpIndex,
			final ValidatorExpression expression) {
		super(expression);
		if (tmpIndex < 0) {
			throw new IllegalArgumentException();
		}
		this.tmpIndex = tmpIndex;
	}

	@Override
	public boolean interpret(final ValidatorContext context) {
		final ValidatorContext newContext = context.copy();
		newContext.setTmpIndex(tmpIndex);
		return super.interpret(newContext);
	}

	public int getTmpIndex() {
		return tmpIndex;
	}
}
