/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils.concurrent;

import java.util.concurrent.locks.Lock;

import woolpack.utils.CheckUtils;

/**
 * {@link #acquire()}で{@link Lock#tryLock()}を実行し、
 * {@link #release()}で{@link Lock#unlock()}を実行する{@link Acquirable}。
 * 適用しているパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class TryLock implements Acquirable {
	private final Lock lock;

	/**
	 * コンストラクタ。
	 * 
	 * @param lock
	 *            委譲先。本クラスはこの引数の状態を変化させる。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public TryLock(final Lock lock) {
		CheckUtils.checkNotNull(lock);
		this.lock = lock;
	}

	public boolean acquire() {
		return lock.tryLock();
	}

	public void release() {
		lock.unlock();
	}

	public Lock getLock() {
		return lock;
	}
}
