/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils.concurrent;

/**
 * 実行権を取得することが可能であることを表す。
 * 
 * @author nakamura
 * 
 */
public interface Acquirable {

	/**
	 * 実行権を取得する。
	 * 実行権が取得可能でない場合に実行権を取得するまで処理をブロックするかは実装に依存する。
	 * また内部で{@link InterruptedException}が発生した場合に割り込み再設定
	 * ({@link Thread#interrupt()})を指定するかは実装に依存する。
	 * 
	 * @return 実行権を取得できた場合は true。それ以外の場合は false。
	 */
	boolean acquire();

	/**
	 * 実行権を解放する。 本メソッドを実行するスレッドが実行権を確保している必要があるかは実装に依存する。
	 */
	void release();
}
