/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Iterator;

/**
 * 委譲先に委譲する{@link Collection}。
 * 
 * @author nakamura
 * 
 */
public class DelegationCollection<T> implements Collection<T> {
	private final Collection<T> child;

	/**
	 * コンストラクタ。
	 * 
	 * @param child
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public DelegationCollection(final Collection<T> child) {
		CheckUtils.checkNotNull(child);
		this.child = child;
	}

	public Iterator<T> iterator() {
		return child.iterator();
	}

	public Object[] toArray() {
		return child.toArray();
	}

	public <T> T[] toArray(final T[] a) {
		return child.toArray(a);
	}

	public boolean remove(final Object o) {
		return child.remove(o);
	}

	public boolean addAll(final Collection<? extends T> c) {
		return child.addAll(c);
	}

	public boolean removeAll(final Collection<?> c) {
		return child.removeAll(c);
	}

	public boolean retainAll(final Collection<?> c) {
		return child.retainAll(c);
	}

	public boolean add(final T o) {
		return child.add(o);
	}

	public boolean containsAll(final Collection<?> c) {
		return child.containsAll(c);
	}

	public boolean contains(final Object o) {
		return child.contains(o);
	}

	public void clear() {
		child.clear();
	}

	public boolean isEmpty() {
		return child.isEmpty();
	}

	public int size() {
		return child.size();
	}

	@Override
	public boolean equals(final Object o) {
		return child.equals(o);
	}

	@Override
	public int hashCode() {
		return child.hashCode();
	}

	@Override
	public String toString() {
		return child.toString();
	}
}
