/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

/**
 * 静的メソッドの集まり。
 * @author nakamura
 *
 */
public final class CheckUtils {
	private CheckUtils() {
	}
	
	/**
	 * 引数が null でないことを検証する。
	 * @param object 検証対象。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public static void checkNotNull(final Object object) {
		object.getClass();
	}
	
	/**
	 * 引数が null でなくかつ空でないことを検証する。
	 * @param s 検証対象。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 * @throws StringIndexOutOfBoundsException
	 *             引数かが空の場合。
	 */
	public static void checkNotEmpty(final String s) {
		if (s.length() == 0) {
			throw new StringIndexOutOfBoundsException();
		}
	}
}
