/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;

import woolpack.utils.CheckUtils;

/**
 * 日付フォーマット処理を委譲する変換器。
 * 
 * @author nakamura
 * 
 */
public class DelegateDateFormat extends DateFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private DateFormat dateFormat;

	/**
	 * コンストラクタ。
	 * 
	 * @param dateFormat
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public DelegateDateFormat(final DateFormat dateFormat) {
		super();
		CheckUtils.checkNotNull(dateFormat);
		this.dateFormat = dateFormat;
		this.setCalendar((Calendar) dateFormat.getCalendar().clone());
		this.setNumberFormat((NumberFormat) dateFormat.getNumberFormat().clone());
	}

	@Override
	public StringBuffer format(final Date date, final StringBuffer toAppendTo,
			final FieldPosition fieldPosition) {
		return dateFormat.format(date, toAppendTo, fieldPosition);
	}

	@Override
	public Date parse(final String source, final ParsePosition pos) {
		return dateFormat.parse(source, pos);
	}

	@Override
	public Object clone() {
		final DelegateDateFormat other = (DelegateDateFormat) super.clone();
		other.dateFormat = (DateFormat) other.dateFormat.clone();
		return other;
	}

	public DateFormat getDateFormat() {
		return dateFormat;
	}
}
