/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

/**
 * オブジェクトを変換することが可能であることを表す。
 * 
 * @author nakamura
 * 
 */
public interface Convertable {

	/**
	 * 変換する。
	 * 
	 * @param beforeValue
	 *            変換前のオブジェクト。
	 * @param toType
	 *            変換先の型。実装ではこのパラメータが動作に反映されない可能性がある。
	 * @param propertyName
	 *            変換元のプロパティ名。
	 * @return 変換後のオブジェクト。
	 */
	Object convert(Object beforeValue, Class toType, String propertyName);
}
