/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリ。 適用しているパターン：Abstract
 * Factory。
 * 
 * @author nakamura
 * 
 */
public interface PropertyELFactory {
	/**
	 * 対象クラスの対象プロパティ名の値を取得するための{@link GettingEL}を返す。
	 * 
	 * @param clazz
	 *            対象クラス。
	 * @param propertyName
	 *            対象クラスの対象プロパティ名。
	 * @return 対象クラスの対象プロパティ名の値を取得する{@link GettingEL}。
	 */
	GettingEL newGetter(Class clazz, String propertyName);

	/**
	 * 対象クラスの対象プロパティ名に値を設定するための{@link EL}を返す。
	 * 
	 * @param clazz
	 *            対象クラス。
	 * @param propertyName
	 *            対象クラスの対象プロパティ名。
	 * @return 対象クラスの対象プロパティ名に値を設定する{@link EL}。
	 */
	EL newSetter(Class clazz, String propertyName);
}
