/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 固定値を返す{@link EL}。
 * 
 * @author nakamura
 * 
 */
public class FixEL extends AbstractEL {
	private final Object value;

	/**
	 * コンストラクタ。
	 * 
	 * @param value
	 *            {@link #getValue(Object, Class)}と
	 *            {@link #getValue(Object)}で返す固定値。
	 */
	public FixEL(final Object value) {
		super();
		this.value = value;
	}

	@Override
	public Object getValue(final Object root, final Class toType) {
		return value;
	}

	@Override
	public void setValue(final Object root, final Object tmpValue) {
		// do nothing.
	}

	public Object getValue() {
		return value;
	}
}
