/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.io.PrintStream;

import woolpack.utils.CheckUtils;

/**
 * 委譲先の実行時間を測定する{@link DomExpression}。 適用しているパターン：Proxy。
 * 
 * @author nakamura
 * 
 */
public class MeasureLapTime implements DomExpression {
	private final DomExpression expression;

	/**
	 * コンストラクタ。
	 * 
	 * @param expression
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public MeasureLapTime(final DomExpression expression) {
		CheckUtils.checkNotNull(expression);
		this.expression = expression;
	}

	public void interpret(final DomContext context) {
		final long s = System.currentTimeMillis();
		expression.interpret(context);
		recode(context, System.currentTimeMillis() - s);
	}

	/**
	 * {@link #interpret(DomContext)}から呼び出される(called)。
	 * デフォルトでは標準出力に委譲先の実行時間を出力する。
	 * 
	 * @param context
	 *            委譲先。
	 * @param time
	 *            委譲先の実行時間。
	 */
	public void recode(final DomContext context, final long time) {
		final PrintStream stream = System.out;
		stream.println("lap time : ");
		stream.println(time);
	}
}
