/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.HashMap;
import java.util.Map;

import woolpack.el.GettingEL;
import woolpack.utils.CheckUtils;

/**
 * {@link GettingEL}の実行結果を返す{@link Evaluable}。 適用しているパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class EvalEL implements Evaluable<Object> {
	/**
	 * {@link DomContext}にアクセスするためのキー。 {@link woolpack.el.PathEL}の "context"
	 * などにより{@link DomContext}にアクセスする。
	 */
	public static final String CONTEXT = "context";

	/**
	 * 固定のオブジェクトにアクセスするためのキー。 {@link woolpack.el.PathEL}の "resource"
	 * などにより固定のオブジェクトにアクセスする。
	 */
	public static final String RESOURCE = "resource";

	private final Object resource;

	private final GettingEL el;

	/**
	 * コンストラクタ。
	 * 
	 * @param resource
	 *            固定のオブジェクト。本クラスはこの引数の状態を変化させないが el がこの引数の状態を変化させる可能性がある。
	 * @param el
	 *            作用への参照。
	 * @throws NullPointerException
	 *             el が null の場合。
	 */
	public EvalEL(final Object resource, final GettingEL el) {
		CheckUtils.checkNotNull(el);

		this.resource = resource;
		this.el = el;
	}

	public Object eval(final DomContext context) {
		final Map<String, Object> map = new HashMap<String, Object>(2);
		map.put(RESOURCE, resource);
		map.put(CONTEXT, context);
		return el.getValue(map);
	}
}
