/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

/**
 * 委譲先を動的に変更することができる{@link DomExpression}。 警告：このクラスはステートレスではないため、Servlet
 * APIへの依存・非依存を切り替えるときのみ使用すべき。 適用しているパターン：Strategy。
 * 
 * @author nakamura
 * 
 */
public class DelegateDomExpression implements DomExpression {
	private DomExpression expression;
	
	public DelegateDomExpression() {
	}

	/**
	 * @throws NullPointerException
	 *             {@link #getExpression()}が null の場合。
	 */
	public void interpret(final DomContext context) {
		expression.interpret(context);
	}

	/**
	 * 現在の委譲先を返す。
	 * 
	 * @return 現在の委譲先。
	 */
	public DomExpression getExpression() {
		return expression;
	}

	/**
	 * 委譲先を設定する。
	 * 
	 * @param expression
	 *            委譲先。
	 */
	public void setExpression(final DomExpression expression) {
		this.expression = expression;
	}
}
