/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DOMノードを再帰的にループする抽象クラス。 スナップショットとしてループする。 ループ最中の変更の影響はその子ノード以外に波及しない。
 * 
 * @author nakamura
 * 
 */
public abstract class AbstractNodeLoop implements DomExpression {

	/**
	 * コンストラクタ。
	 * 
	 */
	public AbstractNodeLoop() {
	}

	/**
	 * @throws NullPointerException
	 *             引数または{@link DomContext#getNode()}が null の場合。
	 * 
	 */
	public void interpret(final DomContext context) {
		final Node[] beforeNodeList;
		{
			final NodeList nodeList = context.getNode().getChildNodes();
			beforeNodeList = new Node[nodeList.getLength()];
			for (int i = 0; i < nodeList.getLength(); i++) {
				beforeNodeList[i] = nodeList.item(i);
			}
		}

		for (int i = 0; i < beforeNodeList.length; i++) {
			final DomContext newContext = context.copy();
			newContext.setNode(beforeNodeList[i]);
			this.interpret(newContext);
		}
	}
}
