/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.ArrayList;
import java.util.Collection;

/**
 * テーブル情報を表す。
 * @author nakamura
 *
 */
public class TableInfo {
	private String catalog;
	private String schema;
	private String name;
	private final Collection<String> columnCollection;
	private final Collection<String> primaryKeyCollection;
	
	/**
	 * コンストラクタ。
	 *
	 */
	public TableInfo() {
		columnCollection = new ArrayList<String>();
		primaryKeyCollection = new ArrayList<String>();
	}
	
//	@Override
//	public String toString() {
//		final StringBuilder sb = new StringBuilder();
//		sb.append("\ncatalog:");
//		sb.append(catalog);
//		sb.append("\nschema:");
//		sb.append(schema);
//		sb.append("\nname:");
//		sb.append(name);
//		sb.append("\ncolumns:");
//		sb.append(columnCollection);
//		sb.append("\nprimary:");
//		sb.append(primaryKeyCollection);
//		sb.append("\n");
//		return sb.toString();
//	}

	public Collection<String> getColumnCollection() {
		return columnCollection;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public Collection<String> getPrimaryKeyCollection() {
		return primaryKeyCollection;
	}

	public String getCatalog() {
		return catalog;
	}

	public void setCatalog(final String catalog) {
		this.catalog = catalog;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(final String schema) {
		this.schema = schema;
	}
}
