/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.List;
import java.util.Map;

/**
 * 問い合わせ可能であることを表す。
 * @author nakamura
 *
 */
public interface Query {
	/**
	 * 問い合わせる。
	 * @param map 条件値の{@link Map}。
	 * @return 問い合わせ結果。
	 */
	List<Map<String, Object>> select(Map<String, List<Object>> map);
}
