/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.List;
import java.util.Map;

import woolpack.utils.CheckUtils;

/**
 * id と{@link TableInfo}の{@link Map}による{@link ExpressionFactory}。
 * @author nakamura
 *
 */
public class ExpressionFactoryImpl implements ExpressionFactory {
	private final Map<String, TableInfo> tableInfoMap;
	private final ExpressionFactory2 factory;
	
	/**
	 * コンストラクタ。
	 * @param tableInfoMap テーブルのJava名称と{@link TableInfo}の{@link Map}。
	 * @param factory 委譲先。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public ExpressionFactoryImpl(
			final Map<String, TableInfo> tableInfoMap,
			final ExpressionFactory2 factory) {
		CheckUtils.checkNotNull(tableInfoMap);
		CheckUtils.checkNotNull(factory);
		this.factory = factory;
		this.tableInfoMap = tableInfoMap;
	}

	public Expression newInstance(final String id, final Map<String, List<Object>> map) {
		return factory.newInstance(tableInfoMap.get(id), map);
	}
}
