/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.List;

/**
 * 値を設定することが可能な、解析されたクエリを表す。
 * @author nakamura
 *
 */
public class Expression {
	private String query;
	private List<InputMapPointer> inputMapPointerList;
	
	/**
	 * コンストラクタ。
	 *
	 */
	public Expression() {
	}
	
	/**
	 * 値をクエリに設定する順序を返す。
	 * @return 値をクエリに設定する順序を返す。
	 */
	public List<InputMapPointer> getInputMapPointerList() {
		return inputMapPointerList;
	}
	
	/**
	 * 値をクエリに設定する順序を設定する。
	 * @param inputMapPointerList 値をクエリに設定する順序。
	 */
	public void setInputMapPointerList(final List<InputMapPointer> inputMapPointerList) {
		this.inputMapPointerList = inputMapPointerList;
	}
	
	/**
	 * クエリを返す。
	 * @return クエリ。
	 */
	public String getQuery() {
		return query;
	}
	
	/**
	 * クエリを設定する。
	 * @param query クエリ。
	 */
	public void setQuery(final String query) {
		this.query = query;
	}
}
