/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.List;
import java.util.Map;

/**
 * 登録・更新・削除用{@link Updatable}と検索用{@link Query}のファクトリ。
 * 適用しているパターン：Facade、Abstract Factory。
 * @author nakamura
 *
 */
public interface CrudFactory {
	
	/**
	 * 登録用{@link Updatable}を生成して返す。
	 * @param id 識別子。
	 * @param map 属性名と属性値の一覧。
	 * @return 生成された登録用{@link Updatable}。
	 */
	Updatable newInsertUpdatable(String id, Map<String, List<Object>> map);

	/**
	 * 検索用{@link Query}を生成して返す。
	 * @param id 識別子。
	 * @param map 属性名と属性値の一覧。
	 * @return 生成された検索用{@link Query}。
	 */
	Query newSelectQuery(String id, Map<String, List<Object>> map);
	
	/**
	 * 更新用{@link Updatable}を生成して返す。
	 * @param id 識別子。
	 * @param map 属性名と属性値の一覧。
	 * @return 生成された更新用{@link Updatable}。
	 */
	Updatable newUpdateUpdatable(String id, Map<String, List<Object>> map);
	
	/**
	 * 削除用{@link Updatable}を生成して返す。
	 * @param id 識別子。
	 * @param map 属性名と属性値の一覧。
	 * @return 生成された削除用{@link Updatable}。
	 */
	Updatable newDeleteUpdatable(String id, Map<String, List<Object>> map);

}
