/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Arrays;

import woolpack.utils.CheckUtils;

/**
 * {@link ConfigExpression}の一覧を順次実行する{@link ConfigExpression}。
 * 
 * @author nakamura
 * 
 */
public class ConfigSerial implements ConfigExpression {
	private final Iterable<? extends ConfigExpression> expressions;

	/**
	 * コンストラクタ。
	 * 
	 * @param expressions
	 *            {@link ConfigExpression}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public ConfigSerial(
			final Iterable<? extends ConfigExpression> expressions) {
		CheckUtils.checkNotNull(expressions);
		this.expressions = expressions;
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param expressions
	 *            {@link ConfigExpression}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public ConfigSerial(final ConfigExpression... expressions) {
		this(Arrays.asList(expressions));
	}

	public void interpret(final ConfigContext context) {
		for (final ConfigExpression e : expressions) {
			e.interpret(context);
		}
	}
}
