/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Map;

/**
 * 単一リクエストまたは単一スレッドごとの設定の{@link Map}への参照を保持するコンテキスト。
 * 本クラスはリクエストごとに生成され単一のスレッドのみからアクセスされる必要がある。 適用しているパターン：Interpreter(Context 役)。
 * 
 * @author nakamura
 * 
 */
public class ConfigContext {
	private Map<String, Object> map;

	/**
	 * コンストラクタ。
	 * 
	 */
	public ConfigContext() {
	}

	/**
	 * 浅いコピーコンストラクタ。 サブクラスだけでなく{@link ConfigExpression}からも呼び出されることを想定しているため
	 * public にしている。
	 * 
	 * @param base
	 *            コピー元。
	 */
	public ConfigContext(final ConfigContext base) {
		this.map = base.map;
	}

	/**
	 * 浅いコピーを行う。{@link java.lang.Cloneable}は実装していない。
	 * 
	 * @return コピーされた{@link ConfigContext}。
	 */
	public ConfigContext copy() {
		return new ConfigContext(this);
	}

	public Map<String, Object> getMap() {
		return map;
	}

	public void setMap(final Map<String, Object> map) {
		this.map = map;
	}
}
