/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import woolpack.utils.CheckUtils;

/**
 * 委譲先のの結果を否定する{@link ForwardMatchable}。 適用しているパターン：Decorator。
 * 
 * @author nakamura
 * 
 */
public class NotForwardMatcher implements ForwardMatchable {
	private final ForwardMatchable matchable;

	/**
	 * コンストラクタ。
	 * 
	 * @param matchable
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public NotForwardMatcher(final ForwardMatchable matchable) {
		CheckUtils.checkNotNull(matchable);
		this.matchable = matchable;
	}

	public final boolean matches(final Object aReturnedObject) {
		return !matchable.matches(aReturnedObject);
	}

	/**
	 * 委譲先を返す。
	 * 
	 * @return 委譲先。
	 */
	public final ForwardMatchable getMatchable() {
		return matchable;
	}
}
