/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

/**
 * メソッド実行結果の受け入れ可否を判定することが可能であることを表す。 イミュータブルなコンストラクタツリーで設定値として使用するため
 * 実装クラスのインスタンスもイミュータブルである必要がある。
 * 
 * @author nakamura
 * 
 */
public interface ForwardMatchable {
	/**
	 * {@link ActionInvoker#findId(Iterable, Object)}から呼び出される(called)。
	 * 実装クラスではメソッド実行結果の受け入れ可否を判定する必要がある。
	 * 
	 * @param aReturnedObject
	 *            メソッドが返却したオブジェクト。
	 * @return マッチするなら true。それ以外は false。
	 */
	boolean matches(Object aReturnedObject);
}
