/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

/**
 * 該当する遷移先定義が見つからない場合にチェックされない例外がスローされる。
 * 
 * @author nakamura
 * 
 */
public class ForwardDefNotFoundRuntimeException extends RuntimeException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final transient Object returnedObject;

	/**
	 * コンストラクタ。
	 * 
	 * @param returnedObject
	 *            メソッドが返却したオブジェクト。
	 */
	public ForwardDefNotFoundRuntimeException(final Object returnedObject) {
		super();
		this.returnedObject = returnedObject;
	}

	/**
	 * メソッドが返却したオブジェクトを返す。
	 * 
	 * @return メソッドが返却したオブジェクト。
	 */
	public Object getReturnedObject() {
		return returnedObject;
	}
}
