/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import woolpack.utils.CheckUtils;

/**
 * アクションの実行結果を表す。
 * 
 * @author nakamura
 * 
 */
public class ActionResult {
	private final ForwardDef forwardDef;

	private final Object returnedObject;

	/**
	 * コンストラクタ。
	 * 
	 * @param forwardDef
	 *            遷移先定義。
	 * @param returnedObject
	 *            メソッドが返却したオブジェクト。
	 * @throws NullPointerException
	 *             forwardDef が null の場合。
	 */
	public ActionResult(
			final ForwardDef forwardDef,
			final Object returnedObject) {
		CheckUtils.checkNotNull(forwardDef);

		this.forwardDef = forwardDef;
		this.returnedObject = returnedObject;
	}

	/**
	 * 遷移先定義を返す。
	 * 
	 * @return 遷移先定義。
	 */
	public ForwardDef getForwardDef() {
		return forwardDef;
	}

	/**
	 * メソッドが返却したオブジェクトを返す。
	 * 
	 * @return メソッドが返却したオブジェクト。
	 */
	public Object getReturnedObject() {
		return returnedObject;
	}
}
