/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.LinkedList;
import woolpack.utils.CheckUtils;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountValidator
implements ValidatorExpression {
    private static final int MAX = 4;
    private final int max;
    private final ValidatorExpression expression;
    private final LinkedList<ValidatorContext> contextList;
    private int count;

    public CountValidator(int max, ValidatorExpression expression) {
        CheckUtils.checkNotNull(expression);
        this.max = max;
        this.expression = expression;
        this.contextList = new LinkedList();
        this.count = 0;
    }

    public CountValidator(ValidatorExpression expression) {
        this(4, expression);
    }

    @Override
    public boolean interpret(ValidatorContext context) {
        ++this.count;
        if (this.max > 0) {
            if (this.count > this.max) {
                this.contextList.removeFirst();
            }
            this.contextList.add(context);
        }
        return this.expression.interpret(context);
    }

    public int getCount() {
        return this.count;
    }

    public LinkedList<ValidatorContext> getContextList() {
        return this.contextList;
    }

    public ValidatorExpression getExpression() {
        return this.expression;
    }
}

