/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils.concurrent;

import java.util.concurrent.Semaphore;
import woolpack.utils.CheckUtils;
import woolpack.utils.concurrent.Acquirable;

public class DoSemaphore
implements Acquirable {
    private final Semaphore semaphore;

    public DoSemaphore(Semaphore semaphore) {
        CheckUtils.checkNotNull(semaphore);
        this.semaphore = semaphore;
    }

    public boolean acquire() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        return true;
    }

    public void release() {
        this.semaphore.release();
    }

    public void processInterruptedException(InterruptedException e) {
        Thread.currentThread().interrupt();
        throw new IllegalStateException(e);
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }
}

