/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import woolpack.utils.CheckUtils;
import woolpack.utils.concurrent.Acquirable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquirableChain
implements Acquirable {
    private final Acquirable[] array;

    public AcquirableChain(Acquirable ... acquirables) {
        CheckUtils.checkNotNull(acquirables);
        this.array = (Acquirable[])acquirables.clone();
    }

    @Override
    public boolean acquire() {
        int i = 0;
        try {
            while (i < this.array.length) {
                if (!this.array[i].acquire()) {
                    break;
                }
                ++i;
            }
        }
        finally {
            if (i < this.array.length) {
                this.release(i - 1);
            }
        }
        return i >= this.array.length;
    }

    private void release(int length) {
        int i = length;
        while (i >= 0) {
            this.array[i].release();
            --i;
        }
    }

    @Override
    public void release() {
        this.release(this.array.length - 1);
    }

    public List<Acquirable> getArray() {
        return Collections.unmodifiableList(Arrays.asList(this.array));
    }
}

