/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrysDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;
    private Iterable<DateFormat> iterable;

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<DateFormat> list = new ArrayList<DateFormat>();
        for (DateFormat s : this.iterable) {
            list.add(s);
        }
        out.writeObject(list);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ArrayList<DateFormat> list = new ArrayList<DateFormat>();
        Iterable it = (Iterable)in.readObject();
        for (Object o : it) {
            list.add((DateFormat)o);
        }
        this.iterable = list;
    }

    public TrysDateFormat(Iterable<DateFormat> iterable) {
        CheckUtils.checkNotNull(iterable);
        this.iterable = iterable;
        DateFormat format = iterable.iterator().next();
        this.setCalendar((Calendar)format.getCalendar().clone());
        this.setNumberFormat((NumberFormat)format.getNumberFormat().clone());
    }

    public TrysDateFormat(DateFormat ... array) {
        this((Iterable<DateFormat>)Arrays.asList(array));
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return TrysDateFormat.copy(this.iterable.iterator().next()).format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        int errorIndex = pos.getErrorIndex();
        for (DateFormat f : this.iterable) {
            ParsePosition pp = new ParsePosition(0);
            pp.setIndex(pos.getIndex());
            pp.setErrorIndex(pos.getErrorIndex());
            Date d = TrysDateFormat.copy(f).parse(source, pp);
            if (d != null) {
                pos.setIndex(pp.getIndex());
                return d;
            }
            errorIndex = pp.getErrorIndex();
        }
        pos.setErrorIndex(errorIndex);
        return null;
    }

    private static DateFormat copy(DateFormat f) {
        return (DateFormat)f.clone();
    }

    public List<DateFormat> getIterable() {
        ArrayList<DateFormat> list = new ArrayList<DateFormat>();
        for (DateFormat f : this.iterable) {
            list.add(TrysDateFormat.copy(f));
        }
        return Collections.unmodifiableList(list);
    }
}

