/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import woolpack.dom.AbstractNodeLoop;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

public final class HtmlConstants {
    private static final Pattern SPACE_PATTERN = Pattern.compile("[ \\t\\r\\n]{2,}");
    public static final DomExpression REMOVE_THIS_AND_TEXTS = new DomExpression(){

        public void interpret(DomContext context) {
            HtmlConstants.removeThisAndText(context.getNode());
        }
    };
    public static final DomExpression NORMALIZE = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.getDocumentNode(context.getNode()).normalize();
        }
    };
    public static final DomExpression NORMALIZE_CASE = new AbstractNodeLoop(){

        public void interpret(DomContext context) {
            super.interpret(context);
            if (context.getNode().getNodeType() == 1) {
                Element e = (Element)context.getNode();
                String s = e.getNodeName().toUpperCase();
                Element newE = s.equals(e.getNodeName()) ? e : DomConstants.getDocumentNode(e).createElement(s);
                NamedNodeMap attrs = e.getAttributes();
                Attr[] attrArray = new Attr[attrs.getLength()];
                int i = 0;
                while (i < attrArray.length) {
                    attrArray[i] = (Attr)attrs.item(i);
                    ++i;
                }
                i = 0;
                while (i < attrArray.length) {
                    Attr attr = attrArray[i];
                    String s2 = attr.getName().toLowerCase();
                    if (e != newE || !s2.equals(attr.getName())) {
                        if (e == newE) {
                            newE.removeAttributeNode(attr);
                        }
                        newE.setAttribute(s2, attr.getNodeValue());
                    }
                    ++i;
                }
                if (e != newE) {
                    Node child = null;
                    while ((child = e.getFirstChild()) != null) {
                        newE.appendChild(child);
                    }
                    e.getParentNode().replaceChild(newE, e);
                }
            }
        }
    };
    public static final DomExpression REMOVE_COMMENT = new AbstractNodeLoop(){

        public void interpret(DomContext context) {
            super.interpret(context);
            if (context.getNode().getNodeType() == 8 && !context.getNode().getParentNode().getNodeName().equals("SCRIPT")) {
                DomConstants.removeThis(context.getNode());
            }
        }
    };
    public static final DomExpression COMPRESS_SPACE = new AbstractNodeLoop(){

        public void interpret(DomContext context) {
            super.interpret(context);
            if (context.getNode().getNodeType() == 3) {
                Text t = (Text)context.getNode();
                Matcher m = SPACE_PATTERN.matcher(t.getWholeText());
                t.replaceWholeText(m.replaceAll(" "));
            }
        }
    };

    private HtmlConstants() {
    }

    public static void removeThisAndText(Node node) {
        Node nextNode = node.getNextSibling();
        while (nextNode != null && nextNode.getNodeType() == 3) {
            DomConstants.removeThis(nextNode);
            nextNode = node.getNextSibling();
        }
        DomConstants.removeThis(node);
    }
}

