/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.InsertElementToParent;
import woolpack.dom.RemoveAttr;
import woolpack.dom.Serial;
import woolpack.dom.UpdateAttrValue;
import woolpack.dom.XPath;
import woolpack.el.FixEL;
import woolpack.html.Frame2TableTdWidth;
import woolpack.utils.CheckUtils;
import woolpack.utils.NodeFindable;
import woolpack.utils.NodeFindableFactory;

public class FrameToTable
implements DomExpression {
    private static final DomExpression BODY = new InsertElementToParent("BODY", DomConstants.NULL);
    static final DomExpression TABLE = new InsertElementToParent("TABLE", new UpdateAttrValue("width", new FixEL("100%")));
    static final DomExpression TR = new InsertElementToParent("TR", DomConstants.NULL);
    private static final DomExpression TD = new InsertElementToParent("TD", new Serial(new UpdateAttrValue("align", new FixEL("left")), new UpdateAttrValue("valign", new FixEL("top"))));
    private final NodeFindable xpathBody;
    private final NodeFindable xpathHtmlBody;
    private final NodeFindable xpathFrame;
    private final NodeFindable xpathFramesetRows;
    private final NodeFindable xpathFramesetCols;
    private final NodeFindable xpathHtml;
    private final NodeFindable xpathFrame2;
    private final String frameId;
    private final DomExpression nodeMaker;
    private final DomExpression framesetRow;
    private final DomExpression root;

    public FrameToTable(String frameId, final String targetName, final DomExpression nodeMaker, NodeFindableFactory factory) {
        CheckUtils.checkNotEmpty(frameId);
        CheckUtils.checkNotEmpty(targetName);
        CheckUtils.checkNotNull(nodeMaker);
        this.nodeMaker = nodeMaker;
        this.frameId = frameId;
        this.xpathBody = factory.newInstance("//BODY");
        this.xpathHtmlBody = factory.newInstance("/HTML/BODY");
        this.xpathFrame = factory.newInstance("//FRAME");
        this.xpathFramesetRows = factory.newInstance("FRAMESET[@rows]");
        this.xpathFramesetCols = factory.newInstance("FRAMESET[@cols]");
        this.xpathHtml = factory.newInstance("/HTML");
        this.xpathFrame2 = factory.newInstance("FRAME");
        final XPath removeTargetAttr = new XPath(factory.newInstance("//*[@target=\"" + targetName + "\"]"), new RemoveAttr("target"));
        DomExpression processFrame = new DomExpression(){

            public void interpret(DomContext context) {
                Element element = (Element)context.getNode();
                if (targetName.equals(element.getAttribute("name"))) {
                    return;
                }
                DomContext newContext = context.copy();
                newContext.setId(element.getAttribute("src"));
                nodeMaker.interpret(newContext);
                removeTargetAttr.interpret(newContext);
                Node target = FrameToTable.this.xpathBody.evaluateOne(newContext.getNode());
                Node child = target.getFirstChild();
                while (child != null) {
                    context.getNode().getParentNode().insertBefore(DomConstants.getDocumentNode(context.getNode()).importNode(child, true), context.getNode());
                    child = child.getNextSibling();
                }
                DomConstants.REMOVE_THIS.interpret(context);
            }
        };
        DomExpression processRow = new DomExpression(){

            public void interpret(DomContext context) {
                FrameToTable.this.framesetRow.interpret(context);
            }
        };
        this.framesetRow = new Serial(new XPath(this.xpathFramesetRows, new Serial(TR, TD, TABLE, processRow, DomConstants.RETAIN_CHILDREN)), new XPath(this.xpathFramesetCols, new Serial(TR, TD, TABLE, TR, new Frame2TableFramesetCol(processRow, processFrame), DomConstants.RETAIN_CHILDREN)), new XPath(this.xpathFrame2, new Serial(TR, TD, processFrame)));
        this.root = new XPath(this.xpathHtml, new Serial(new XPath(this.xpathFramesetRows, new Serial(BODY, TABLE, processRow, DomConstants.RETAIN_CHILDREN)), new XPath(this.xpathFramesetCols, new Serial(BODY, TABLE, TR, new Frame2TableFramesetCol(processRow, processFrame), DomConstants.RETAIN_CHILDREN))));
    }

    public void interpret(DomContext context) {
        DomContext frameContext = context.copy();
        frameContext.setId(this.frameId);
        this.nodeMaker.interpret(frameContext);
        this.root.interpret(frameContext);
        Node base = frameContext.getNode();
        this.nodeMaker.interpret(context);
        Node baseBody = DomConstants.getDocumentNode(context.getNode()).importNode(this.xpathHtmlBody.evaluateOne(base), true);
        Node baseFrame = this.xpathFrame.evaluateOne(baseBody);
        Node targetBody = this.xpathHtmlBody.evaluateOne(context.getNode());
        Node child = targetBody.getFirstChild();
        while (child != null) {
            baseFrame.getParentNode().insertBefore(child, baseFrame);
            child = targetBody.getFirstChild();
        }
        Node baseTd = baseFrame.getParentNode();
        baseTd.removeChild(baseFrame);
        Node child2 = baseBody.getFirstChild();
        while (child2 != null) {
            targetBody.appendChild(child2);
            child2 = baseBody.getFirstChild();
        }
    }

    class Frame2TableFramesetCol
    implements DomExpression {
        private final DomExpression processRow;
        private final DomExpression processFrame;

        Frame2TableFramesetCol(DomExpression processRow, DomExpression processFrame) {
            this.processRow = processRow;
            this.processFrame = processFrame;
        }

        public void interpret(DomContext context) {
            InsertElementToParent e0 = new InsertElementToParent("TD", new Serial(new UpdateAttrValue("align", new FixEL("left")), new UpdateAttrValue("valign", new FixEL("top")), new Frame2TableTdWidth(((Element)context.getNode()).getAttribute("cols"))));
            Serial e1 = new Serial(new XPath(FrameToTable.this.xpathFramesetRows, new Serial(e0, TABLE, this.processRow, DomConstants.RETAIN_CHILDREN)), new XPath(FrameToTable.this.xpathFramesetCols, new Serial(e0, TABLE, TR, new Frame2TableFramesetCol(this.processRow, this.processFrame), DomConstants.RETAIN_CHILDREN)), new XPath(FrameToTable.this.xpathFrame2, new Serial(e0, this.processFrame)));
            e1.interpret(context);
        }
    }
}

