/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Element;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.html.PropertyCounter;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCountProperty
implements DomExpression {
    public static final String KEY = "woolpack.html.IF_DUPLICATE_PROPERTY_COUNTER";
    private final String key;
    private final Iterable<String> attrNames;

    public AbstractCountProperty(String key, Iterable<String> attrNames) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(attrNames);
        this.key = key;
        this.attrNames = attrNames;
    }

    public AbstractCountProperty(Iterable<String> attrNames) {
        this(KEY, attrNames);
    }

    @Override
    public void interpret(DomContext context) {
        if (context.getNode().getNodeType() != 1) {
            return;
        }
        PropertyCounter counter = (PropertyCounter)context.getLocal().get(this.key);
        if (counter == null) {
            counter = new PropertyCounter();
            context.getLocal().put(this.key, counter);
        }
        Element element = (Element)context.getNode();
        for (String attrName : this.attrNames) {
            if (!element.hasAttribute(attrName)) continue;
            counter.put(attrName, element.getAttribute(attrName));
            this.interpret(context, counter);
        }
    }

    public abstract void interpret(DomContext var1, PropertyCounter var2);
}

