/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.util.Arrays;
import woolpack.el.convert.Convertable;
import woolpack.utils.CheckUtils;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialConverter
implements Convertable {
    private final Iterable<Convertable> iterable;

    public SerialConverter(Iterable<Convertable> iterable) {
        CheckUtils.checkNotNull(iterable);
        this.iterable = iterable;
    }

    public SerialConverter(Convertable ... array) {
        this((Iterable<Convertable>)Arrays.asList(array));
    }

    @Override
    public Object convert(Object beforeValue, Class toType, String propertyName) {
        Object o = beforeValue;
        for (Convertable c : this.iterable) {
            o = c.convert(o, toType, propertyName);
        }
        return o;
    }

    public Iterable<Convertable> getIterable() {
        return UtilsConstants.unmodifiableIterable(this.iterable);
    }
}

