/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.Arrays;
import java.util.Collection;
import woolpack.el.AbstractEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPathEL
extends AbstractEL {
    private final GettingEL[] getting;
    private final EL setting;

    public ArrayPathEL(GettingEL[] getting, EL setting) {
        CheckUtils.checkNotNull(getting);
        CheckUtils.checkNotNull(setting);
        this.getting = (GettingEL[])getting.clone();
        this.setting = setting;
    }

    public ArrayPathEL(GettingEL getting, EL setting) {
        this(new GettingEL[]{getting}, setting);
        CheckUtils.checkNotNull(getting);
    }

    public ArrayPathEL(Collection<? extends GettingEL> getting, EL setting) {
        this(getting.toArray(new GettingEL[0]), setting);
    }

    public ArrayPathEL(EL ... setting) {
        this((Collection<? extends GettingEL>)Arrays.asList(setting).subList(0, setting.length - 1), setting[setting.length - 1]);
    }

    public ArrayPathEL(Collection<? extends EL> setting) {
        this(setting.toArray(new EL[0]));
    }

    private Object getLocal(Object root) {
        Object r = root;
        int i = 0;
        while (i < this.getting.length) {
            r = this.getting[i].getValue(r);
            ++i;
        }
        return r;
    }

    @Override
    public void setValue(Object root, Object value) {
        this.setting.setValue(this.getLocal(root), value);
    }

    @Override
    public Object getValue(Object root, Class toType) {
        return this.setting.getValue(this.getLocal(root), toType);
    }

    public GettingEL[] getGetting() {
        return (GettingEL[])this.getting.clone();
    }

    public EL getSetting() {
        return this.setting;
    }
}

