/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import woolpack.utils.AbstractKeyIteratorMap;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionMap
extends AbstractKeyIteratorMap<String, Object> {
    private final HttpSession child;

    public HttpSessionMap(HttpSession child) {
        CheckUtils.checkNotNull(child);
        this.child = child;
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        final Enumeration e = this.child.getAttributeNames();
        return new Iterator<String>(){
            private Object key;

            @Override
            public void remove() {
                HttpSessionMap.this.remove(this.key);
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public String next() {
                this.key = e.nextElement();
                return (String)this.key;
            }
        };
    }

    @Override
    protected Object getValue(Object key) {
        return this.child.getAttribute((String)key);
    }

    @Override
    public Object get(Object key) {
        return this.getValue((String)key);
    }

    @Override
    public Object put(String key, Object value) {
        Object before = this.getValue(key);
        this.child.setAttribute(key, value);
        return before;
    }

    @Override
    public Object remove(Object key) {
        Object before = this.getValue(key);
        this.child.removeAttribute((String)key);
        return before;
    }
}

