/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;
import woolpack.utils.NodeFindable;

public class XPath
implements DomExpression {
    private final NodeFindable findable;
    private final DomExpression firstExpression;
    private final DomExpression pluralExpression;

    public XPath(NodeFindable findable, DomExpression firstExpression, DomExpression pluralExpression) {
        CheckUtils.checkNotNull(findable);
        CheckUtils.checkNotNull(firstExpression);
        CheckUtils.checkNotNull(pluralExpression);
        this.findable = findable;
        this.firstExpression = firstExpression;
        this.pluralExpression = pluralExpression;
    }

    public XPath(NodeFindable findable, DomExpression expression) {
        this(findable, expression, expression);
    }

    public void interpret(DomContext context) {
        NodeList nodeList = this.findable.evaluateList(context.getNode());
        Node[] beforeNodeList = new Node[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            beforeNodeList[i] = nodeList.item(i);
            ++i;
        }
        i = 0;
        while (i < beforeNodeList.length) {
            DomContext newContext = context.copy();
            newContext.setNode(beforeNodeList[i]);
            if (i == 0) {
                this.firstExpression.interpret(newContext);
            } else {
                this.pluralExpression.interpret(newContext);
            }
            ++i;
        }
    }
}

