/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveInputForBack
implements DomExpression {
    public static final String KEY = "woolpack.dom.SAVE_INPUT_FOR_BACK";
    private final String key;
    private final DomExpression expression;
    private final Map<String, String> toRequestIdMap;
    private final Map<String, String> toInputIdMap;

    public SaveInputForBack(String key, DomExpression expression, Map<String, String> toRequestIdMap, Map<String, String> toInputIdMap) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(expression);
        CheckUtils.checkNotNull(toRequestIdMap);
        CheckUtils.checkNotNull(toInputIdMap);
        this.key = key;
        this.expression = expression;
        this.toRequestIdMap = toRequestIdMap;
        this.toInputIdMap = toInputIdMap;
    }

    public SaveInputForBack(DomExpression expression, Map<String, String> toRequestIdMap, Map<String, String> toInputIdMap) {
        this(KEY, expression, toRequestIdMap, toInputIdMap);
    }

    private Map<String, Map> createPerSession(ConcurrentMap<String, Object> session) {
        Map map;
        while ((map = (Map)session.get(this.key)) == null) {
            map = Collections.synchronizedMap(new HashMap());
            session.putIfAbsent(this.key, map);
        }
        return map;
    }

    @Override
    public void interpret(DomContext context) {
        String requestId;
        Map m;
        Map<String, Map> map = this.createPerSession(context.getSession());
        String inputId = this.toInputIdMap.get(context.getId());
        if (inputId != null && (m = map.get(this.toInputIdMap.get(context.getId()))) != null) {
            context.setInput(m);
        }
        if (this.toInputIdMap.containsValue(context.getId())) {
            map.put(context.getId(), context.getInput());
        }
        if ((requestId = this.toRequestIdMap.get(context.getId())) != null) {
            context.setId(requestId);
        }
        this.expression.interpret(context);
    }
}

