/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;

public class InsertElementToChild
implements DomExpression {
    private final String elementName;
    private final DomExpression expression;

    public InsertElementToChild(String elementName) {
        this(elementName, DomConstants.NULL);
    }

    public InsertElementToChild(String elementName, DomExpression expression) {
        CheckUtils.checkNotEmpty(elementName);
        CheckUtils.checkNotNull(expression);
        this.elementName = elementName;
        this.expression = expression;
    }

    public void interpret(DomContext context) {
        Element element = DomConstants.getDocumentNode(context.getNode()).createElement(this.elementName);
        Node child = null;
        while ((child = context.getNode().getFirstChild()) != null) {
            element.appendChild(child);
        }
        context.getNode().appendChild(element);
        DomContext newContext = context.copy();
        newContext.setNode(element);
        this.expression.interpret(newContext);
    }
}

