/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.Evaluable;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.el.MapEL;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalNetMask
implements Evaluable<String> {
    private static final int IP_COUNT = 4;
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
    public static final GettingEL KEY = new ArrayPathEL(DomConstants.LOCAL_EL, (EL)new MapEL("woolpack.dom.NET_MASK"));
    private final GettingEL addressEL;
    private final int[] maskArray;

    public EvalNetMask(GettingEL addressEL, String netMask) {
        CheckUtils.checkNotNull(addressEL);
        CheckUtils.checkNotNull(netMask);
        this.maskArray = EvalNetMask.toArray(netMask);
        if (this.maskArray == null) {
            throw new IllegalArgumentException();
        }
        this.addressEL = addressEL;
    }

    public EvalNetMask(String netMask) {
        this(KEY, netMask);
    }

    private static int[] toArray(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] a = new int[4];
        int i = 0;
        while (i < a.length) {
            a[i] = Integer.parseInt(m.group(i + 1));
            ++i;
        }
        return a;
    }

    @Override
    public String eval(DomContext context) {
        String address = (String)this.addressEL.getValue(context, String.class);
        int[] a = EvalNetMask.toArray(address);
        if (a == null) {
            return null;
        }
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] & this.maskArray[i];
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < a.length) {
            if (i2 != 0) {
                sb.append('.');
            }
            sb.append(a[i2]);
            ++i2;
        }
        return sb.toString();
    }
}

