/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.LinkedList;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Count
implements DomExpression {
    private static final int MAX = 4;
    private final int max;
    private final DomExpression expression;
    private int count;
    private final LinkedList<DomContext> contextList;

    public Count(int max, DomExpression expression) {
        CheckUtils.checkNotNull(expression);
        this.max = max;
        this.expression = expression;
        this.contextList = new LinkedList();
        this.count = 0;
    }

    public Count(DomExpression expression) {
        this(4, expression);
    }

    @Override
    public void interpret(DomContext context) {
        ++this.count;
        if (this.max > 0) {
            if (this.count > this.max) {
                this.contextList.removeFirst();
            }
            this.contextList.add(context);
        }
        this.expression.interpret(context);
    }

    public int getCount() {
        return this.count;
    }

    public LinkedList<DomContext> getContextList() {
        return this.contextList;
    }
}

