/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import org.w3c.dom.Element;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;
import woolpack.utils.Switchable;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchByAttrValue
implements DomExpression {
    private final Iterable<String> attrNames;
    private final Switchable<String, DomExpression> switchable;

    public BranchByAttrValue(Iterable<String> attrNames, Switchable<String, DomExpression> switchable) {
        CheckUtils.checkNotNull(attrNames);
        CheckUtils.checkNotNull(switchable);
        this.attrNames = attrNames;
        this.switchable = UtilsConstants.nullToDefaultSwitchIfAbsent(DomConstants.NULL, switchable);
    }

    @Override
    public void interpret(DomContext context) {
        Element element = (Element)context.getNode();
        for (String attrName : this.attrNames) {
            String value = element.getAttribute(attrName);
            if (!this.switchable.keys().contains(value)) continue;
            this.switchable.get(value).interpret(context);
            return;
        }
        this.switchable.getDefault().interpret(context);
    }
}

