/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.Map;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchButton
implements DomExpression {
    private final String key;
    private final Map<String, Map<String, String>> map;

    public BranchButton(String key, Map<String, Map<String, String>> map) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(map);
        this.key = key;
        this.map = map;
    }

    @Override
    public void interpret(DomContext context) {
        Map<String, String> m = this.map.get(context.getId());
        if (m != null) {
            String newId = null;
            Object value = context.getInput().get(this.key);
            if (value != null) {
                newId = m.get(value);
            }
            if (newId == null) {
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    Object value2 = context.getInput().get(entry.getKey());
                    if (value2 == null || value2.equals("")) continue;
                    newId = entry.getValue();
                    break;
                }
            }
            if (newId != null) {
                context.setId(newId);
            }
        }
    }
}

